'use strict';

parcel_services.controllers.module('overview', ['xhr', 'loading_spinner', gx.source + '/libs/info_messages'], function () {
	return {
		vue: true,
		name: 'gx-parcel-services-overview',
		template: '#parcel-services-overview',
		props: ['languages'],
		data: function data() {
			return {
				page: 1,
				offset: 0,
				limit: 10,
				totalItems: 0,
				totalPages: 1,
				sortOrder: 'asc',
				lang: {
					columns: {
						name: jse.core.lang.translate('label_name', 'parcel_services'),
						isDefault: jse.core.lang.translate('label_is_default', 'parcel_services')
					},
					pagination: {
						limits: {
							10: jse.core.lang.translate('option_limits_10', 'parcel_services'),
							25: jse.core.lang.translate('option_limits_25', 'parcel_services'),
							50: jse.core.lang.translate('option_limits_50', 'parcel_services'),
							100: jse.core.lang.translate('option_limits_100', 'parcel_services')
						},
						offset: {
							of: jse.core.lang.translate('label_offset_of', 'parcel_services'),
							to: jse.core.lang.translate('label_offset_to', 'parcel_services')
						},
						page: {
							previous: jse.core.lang.translate('label_page_previous', 'parcel_services'),
							next: jse.core.lang.translate('label_page_next', 'parcel_services')
						}
					},
					labels: {
						noParcelServicesExist: jse.core.lang.translate('label_no_data', 'parcel_services'),
						isDefault: jse.core.lang.translate('label_is_default', 'parcel_services')
					},
					create: jse.core.lang.translate('create', 'buttons')
				},
				parcelServices: [],
				deleteDetails: undefined,
				editDetails: undefined,
				parsedLanguages: []
			};
		},
		methods: {
			loadTableData: function loadTableData() {
				var vm = this;
				var $target = $('table.parcel-services');
				var spinner = jse.libs.loading_spinner.show($target);

				jse.libs.xhr.get({
					url: './api/parcel-services',
					data: {
						limit: this.limit,
						offset: this.offset,
						order: this.sortOrder
					}
				}).done(function (response) {
					vm.parcelServices = response.parcelServices;
					vm.totalItems = response.totalItems;
					vm.totalPages = Math.ceil(vm.totalItems / vm.limit);
					jse.libs.loading_spinner.hide(spinner);
				}).fail(function (response) {
					console.error('Could not load parcel services.', response);
					jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_load_parcel_services', 'parcel_services'));
					jse.libs.loading_spinner.hide(spinner);
					vm.parcelServices = [];
					vm.totalItems = 0;
					vm.totalPages = 1;
				});
			},
			showPreviousPage: function showPreviousPage() {
				this.page = this.page === 1 ? 1 : this.page - 1;
				this.updateOffset();
			},
			showNextPage: function showNextPage() {
				this.page = this.page === this.totalPages ? this.totalPages : this.page + 1;
				this.updateOffset();
			},
			updatedLimit: function updatedLimit() {
				this.page = 1;
				this.offset = (this.page - 1) * this.limit;
				this.loadTableData();
			},
			updateOffset: function updateOffset() {
				this.offset = (this.page - 1) * this.limit;
				this.loadTableData();
			},
			changeSorting: function changeSorting() {
				this.sortOrder = this.sortOrder === 'desc' ? 'asc' : 'desc';
				this.loadTableData();
			},
			openCreateModal: function openCreateModal() {
				this.$children[0].openModal();
			},
			openEditModal: function openEditModal(editDetails) {
				this.$children[1].openModal(editDetails);
			},
			openDeleteModal: function openDeleteModal(deleteDetails) {
				this.$children[2].openModal(deleteDetails);
			}
		},
		mounted: function mounted() {
			this.parsedLanguages = JSON.parse(this.languages);
			this.loadTableData();
		},

		init: function init(done) {
			return done();
		}
	};
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
